/*
    calls2.c - callbacks 020 through 029 (formerly in calls.c)

    Marc Wolfgram,  3/30/91 11:55:50
    ---------------------------------------------------------------
*/
#pragma noroot
#pragma keep "o/calls2"

#include "calls.h"

segment "F_CALLBACK";

/*
    fGetResourceSize 020
    ---------------------------------------------------------------
        word    pCount          3 or 4
        word    resType         input
        Long    resID           input
        Long    result          retVal
        word    resFileID       input

    Marc Wolfgram,  7/25/91 0:04:22
*/
word remGetResourceSize(fResData2RecPtr p)
{
word retVal, curFile, curDepth, file;

    retVal = 0;
    file = workList[workIndex].resFileID;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(2);

    switch(p->pCount) {
    case 4:
        file = p->resFileID;

    case 3:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);

        p->result = GetResourceSize(p->resType, p->resID);
        retVal = toolerror();

        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}

/*
    fSetResourceID 021
    ---------------------------------------------------------------
        word    pCount          3 or 4
        word    resType         input
        Long    resID           input
        Long    result          both
        word    resFileID       input

    Marc Wolfgram,  7/25/91 0:04:22
*/
word remSetResourceID(fResData2RecPtr p)
{
word retVal, curFile, curDepth, file;

    retVal = 0;
    file = workList[workIndex].resFileID;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(1);

    switch(p->pCount) {
    case 4:
        file = p->resFileID;

    case 3:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);

        SetResourceID(p->result, p->resType, p->resID);
        retVal = toolerror();
        if (!retVal)
            changeItem(workIndex, p->resType, p->resID, p->result, (char *) 0L);

        UpdateResourceFile(file);
        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}

/*
    fGetResourceAttr 022
    ---------------------------------------------------------------
        word    pCount          4 or 5
        word    resType         input
        Long    resID           input
        Handle  resData         ignored
        word    special         retval
        word    resFileID       input
        Pointer resName         ignored

    Marc Wolfgram, 10/ 2/91 23:53:26
*/
word remGetResourceAttr(fResDataRecPtr p)
{
word retVal, curFile, curDepth, file;

    retVal = 0;
    file = workList[workIndex].resFileID;
    tempName[0] = 0x00;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(1);

    switch (p->pCount) {
    case 5:
        if (p->resFileID)
            file = p->resFileID;

    case 4:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);

        p->special = GetResourceAttr(p->resType, p->resID);
        retVal = toolerror();

        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}

/*
    fSetResourceAttr 023
    ---------------------------------------------------------------
        word    pCount          4 or 5
        word    resType         input
        Long    resID           input
        Handle  resData         ignored
        word    special         retval
        word    resFileID       input
        Pointer resName         ignored

    Marc Wolfgram,  10/ 3/91  0:01:46
*/
word remSetResourceAttr(fResDataRecPtr p)
{
word retVal, curFile, curDepth, file;

    retVal = 0;
    file = workList[workIndex].resFileID;
    tempName[0] = 0x00;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(1);

    switch (p->pCount) {
    case 5:
        if (p->resFileID)
            file = p->resFileID;

    case 4:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);

        SetResourceAttr(p->special & 0xffdf, p->resType, p->resID);
        retVal = toolerror();

        UpdateResourceFile(file);
        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}

/*
    fResourceConverter 024
    ---------------------------------------------------------------
        word    pCount          3
        word    resType         input
        Long    converterProc   input
        word    logFlags        input

    Marc Wolfgram,  7/25/91 0:04:22
*/
word remResourceConverter(fResConverterRecPtr p)
{
word retVal;

    retVal = 0;

    if (p->pCount != 3)
        retVal = invalidPcount;
    else
        ResourceConverter((Pointer) p->converterProc, p->resType, p->logFlags);

    return SetToolError(retVal);
}

/*
    fCopyResource 025
    ---------------------------------------------------------------
        word    pCount          min 3
        word    resType         input
        Long    resID           input
        Long    newID           input or retVal
        word    attr            input
        word    resFileID       input
        word    newFileID       input
        Pointer newName         input

    Marc Wolfgram,  4/ 7/91 13:12:29
*/
word remCopyResource(fResCopyRecPtr p)
{
word retVal, desc, oldattr, newattr, oldfile, newfile;
long curFile;
Handle theRes;

    copyFlag = 9;
    retVal = 0;
    newattr = 0;
    oldfile = newfile = workList[workIndex].resFileID;
    tempName[0] = 0x00;

    switch (p->pCount) {
    case 7:
        sprintf(tempName, "*%.31b", p->resName);
        tempName[0] = strlen(&tempName[1]);

    case 6:
        if (p->newFileID)
            newfile = p->newFileID;

    case 5:
        if (p->resFileID)
            oldfile = p->resFileID;
    case 4:
        newattr = p->attr;

    case 3:
        if ((p->pCount == 5 && !oldfile) || (p->pCount == 6 && !newfile)) {
            retVal = resFileNotFound;
            break;
        }

		p->newID = CopyResource(oldfile, newfile, p->resType, p->resID);

    	if (p->newID){
            if (tempName[0]) {
                if (workList[workIndex].resFileID == newfile)
                    changeItem(workIndex, p->resType, p->newID, 0L, tempName);
                else {
                    curFile = SetResFile2(newfile, 1);
                    RMSetResourceName(p->resType, p->newID, tempName);
                    SetResFile1(curFile);
                }
            }
        }
        else
            retVal = resNotFound;
        break;

    default:
        retVal = invalidPcount;
    }

    return SetToolError(retVal);
}

/*
    fAddPrivateData 026
    ---------------------------------------------------------------
        word    pCount          7
        Pointer winPtr          input
        long    remTaskMask     input
        word    remSignature    input
        Handle  data            input
        word    groupSignature  input
        word    resType         input
        long    resID           input

    Marc Wolfgram,  9/16/91 18:41:53
*/
word remAddPrivateData(fPrivateDataRecPtr p)
{
word retVal;
fWindowRecHndl  refH;
fWindowRecPtr   refP;
    retVal = 0;
    if (p->pCount == 7) {
        switch (p->groupSignature) {
        case 0x0020:
        case 0x0060:
            if (p->resID <= 0L || p->resID > 0x07ffffffL) {
                retVal = resInvalidTypeOrID;
                break;
            }
        case 0x0010:
            if ((p->resType & 0x7fff) == 0) {
                retVal = resInvalidTypeOrID;
                break;
            }
        case 0x0040:
            refH = (fWindowRecHndl) NewHandle(20L, fMemID, 0x0018, 0L);
            refP = (fWindowRecPtr) deref((Handle) refH);
            refP->Signature = REM_signature + p->groupSignature + workIndex;
            refP->resType = p->resType;
            refP->resID = p->resID;
            refP->resFileID = workList[workIndex].resFileID;
            if (p->remTaskMask > 0L)
                refP->remTaskMask = p->remTaskMask;
            else
                refP->remTaskMask = masterTaskMask;
            refP->remSignature = p->remSignature;
            refP->resPrivate = p->Data;
            HUnlock((Handle) refH);
            SetWRefCon((Longint) refH, (GrafPortPtr) p->winPtr);
            break;
        default:
            retVal = fBadGroupError;
            break;
        }
    }
    else
        retVal = invalidPcount;

    return SetToolError(retVal);
}

/*
    fRelPrivateData 027
    ---------------------------------------------------------------
        word    pCount          1
        Pointer winPtr          input
        long    remTaskMask     ignored
        word    remSignature    ignored
        Handle  data            ignored
        word    groupSignature  ignored
        word    resType         ignored
        long    resID           ignored

    Marc Wolfgram,  9/16/91 18:40:08
*/
word remRelPrivateData(fPrivateDataRecPtr p)
{
word retVal;
fWindowRecHndl  refH;

    retVal = 0;
    if (p->pCount == 1) {
        refH = (fWindowRecHndl) GetWRefCon((GrafPortPtr) p->winPtr);
        if (((**refH).Signature & 0xff80) == REM_signature) {
            DisposeHandle((Handle) refH);
            SetWRefCon(0L, (GrafPortPtr) p->winPtr);
        }
        else
            retVal = fBadGroupError;
    }
    else
        retVal = invalidPcount;

    return SetToolError(retVal);
}

/*
    fDisposeLinkHand 028
    ---------------------------------------------------------------
        word    pCount          2
        word    index           (ignored)
        Handle  linkHand        input
        word    hostType        (ignored)
        Long    hostID          (ignored)
        word    resType         (ignored)
        Long    resID           (ignored)
        Word    resCheck        (ignored)
        word    resFileID       (ignored)

    Marc Wolfgram,  10/18/91 17:56:21
*/
word remDisposeLinkHand(fResLinkRecPtr p)
{
word retVal;

    switch (p->pCount) {
    case 2:
        DisposeHandle(p->linkHand);
        retVal = toolerror();

    default:
        retVal = invalidPcount;
    }

    return SetToolError(retVal);
}

/*
    remGetWindowTitle 029
    ---------------------------------------------------------------
        word    pCount          3
        word    resType         input
        Long    resID;          input
        char   *resName         output

    Marc Wolfgram,  7/13/91 12:22:04
*/
word remGetWindowTitle(fResNameRecPtr p)
{
word nlen, retVal;
char *s;
namePtr    nameP;

    retVal = 0;
    p->resName[0] = 0x00;

    if (p->pCount != 3)
        retVal = invalidPcount;

    else if (p->resType == 0 || p->resType == 0x8000 || p->resID > 0x07ffffff)
        retVal = resInvalidTypeOrID;

   else if (p->resID == 0L) { /* must be a native selector */
       nameP = getNameRec(workIndex, p->resType);
       strncpy(p->resName, nameP->winT, (int) nameP->winT[0] + 1);
    }
    else {
        s = p->resName;
        p->resName = &tempName[128];
        remGetStdTypeName(p);
        p->resName = &tempName[192];
        remGetResourceName(p);
        if (p->resName[0])
            nlen = (char) sprintf(s, "* %b - %0.8lX %b (%c) ", &tempName[128],
                p->resID, p->resName, (char) workIndex + '1');
        else
            nlen = (char) sprintf(s, "* %b - %0.8lX (%c) ", &tempName[128],
                p->resID, (char) workIndex + '1');
        s[0] = (char) nlen -1;
        p->resName = s;
    }
    return SetToolError(retVal);
}
